# -*- coding: utf-8 -*-
"""Bagging.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/1bD3Z2pof8RH0NVekldYUb2KmAVTDjLzH
"""

from sklearn.ensemble import BaggingClassifier, BaggingRegressor
from sklearn.tree import DecisionTreeClassifier
from sklearn.datasets import make_classification, load_diabetes
from sklearn.model_selection import train_test_split
from sklearn.metrics import accuracy_score, mean_squared_error

## 1. Classification Example with Bagging

# Generate synthetic classification data
X, y = make_classification(n_samples=1000, n_features=20, n_informative=15,
                           n_redundant=5, random_state=42)

# Split data
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.3, random_state=42)

# Create base estimator (typically a weak learner)
base_estimator = DecisionTreeClassifier(max_depth=3)

# Create Bagging classifier
bagging_clf = BaggingClassifier(
    estimator=base_estimator, # Changed from base_estimator to estimator
    n_estimators=50,  # Number of base estimators
    max_samples=0.8,  # Percentage of samples to draw from X to train each base estimator
    max_features=0.8,  # Percentage of features to draw from X to train each base estimator
    random_state=42,
    n_jobs=-1  # Use all available cores
)

# Train the model
bagging_clf.fit(X_train, y_train)

# Make predictions
y_pred = bagging_clf.predict(X_test)

# Evaluate
print(f"Bagging Classifier Accuracy: {accuracy_score(y_test, y_pred):.4f}")

## 2. Regression Example with Bagging

# Load diabetes dataset
diabetes = load_diabetes()
X, y = diabetes.data, diabetes.target

# Split data
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.3, random_state=42)

# Create Bagging regressor
bagging_reg = BaggingRegressor(
    n_estimators=100,
    max_samples=0.8,
    max_features=0.8,
    random_state=42,
    n_jobs=-1
)

# Train the model
bagging_reg.fit(X_train, y_train)

# Make predictions
y_pred = bagging_reg.predict(X_test)

# Evaluate
print(f"Bagging Regressor MSE: {mean_squared_error(y_test, y_pred):.4f}")